/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.syntax;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import replicatorg.app.Base;
import replicatorg.app.syntax.CTokenMarker;
import replicatorg.app.syntax.KeywordMap;

public class PdeKeywords
extends CTokenMarker {
    static KeywordMap keywordColoring;
    static Hashtable<String, String> keywordToReference;

    public PdeKeywords() {
        super(false, PdeKeywords.getKeywords());
    }

    public static KeywordMap getKeywords() {
        if (keywordColoring == null) {
            try {
                keywordColoring = new KeywordMap(false);
                keywordToReference = new Hashtable();
                InputStream input = Base.getStream("keywords.txt");
                InputStreamReader isr = new InputStreamReader(input);
                BufferedReader reader = new BufferedReader(isr);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String htmlFilename;
                    String[] pieces;
                    if (line.length() > 0 && '#' == line.charAt(0) || (pieces = line.split("\t")).length < 2) continue;
                    String keyword = pieces[0].trim();
                    String coloring = pieces[1].trim();
                    if (coloring.length() > 0) {
                        boolean isKey = coloring.charAt(0) == 'K';
                        int num = coloring.charAt(coloring.length() - 1) - 49;
                        byte id = (byte)((isKey ? 6 : 3) + num);
                        keywordColoring.add(keyword, id);
                    }
                    if (pieces.length < 3 || (htmlFilename = pieces[2].trim()).length() <= 0) continue;
                    keywordToReference.put(keyword, htmlFilename);
                }
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return keywordColoring;
    }

    public static String getReference(String keyword) {
        return keywordToReference.get(keyword);
    }

    public static KeywordMap getKeywordColoring() {
        return keywordColoring;
    }
}

